﻿// define namespace.
Type.registerNamespace("GridSoft.Variations");

// default settings, is set from AdditionalPageHead.ascx
GridSoft.Variations.Url = null;
GridSoft.Variations.ListId = null;
GridSoft.Variations.ItemId = null;
GridSoft.Variations.SettingsEnabled = false;
GridSoft.Variations.OverwriteEnabled = false;
GridSoft.Variations.CreateEnabled = false;

GridSoft.Variations.IsSettingsEnabled = function() { 
    return this.SettingsEnabled;
};
    
GridSoft.Variations.IsCreateEnabled = function() { 
    return this.CreateEnabled;
};
    
GridSoft.Variations.IsOverwriteEnabled = function() { 
    return this.OverwriteEnabled;
};

GridSoft.Variations.SettingsAction = function () {
    if (this.IsSettingsEnabled()) {
        SP.UI.ModalDialog.showModalDialog({
            url: this.Url + "Settings.aspx",
            title: "GRIDSOFT Variations",
            allowMaximize: false,
            showClose: true,
            dialogReturnValueCallback: function (dialogResult, returnValue) {
                if (dialogResult == SP.UI.DialogResult.OK) {
                    SP.UI.Notify.addNotification('Einstellungen der Variationen gespeichert.');
                }
            }
        });
    }
};
           
GridSoft.Variations.CreateAction = function() {
    if (this.IsCreateEnabled()) {
        SP.UI.ModalDialog.showModalDialog({
            url: this.Url + "Create.aspx?ListId=" + this.ListId + "&ItemId=" + this.ItemId,
            title: "GRIDSOFT Variations",
            allowMaximize: false,
            showClose: true,
            width: 540,
            height: 270,
            dialogReturnValueCallback: function (dialogResult, returnValue) {
                if (dialogResult == SP.UI.DialogResult.OK) {
                    SP.UI.Notify.addNotification('Variationen erfolgreich erstellt.');
                }
            }
        });
    }
};

GridSoft.Variations.OverwriteAction = function() {
    if (this.IsOverwriteEnabled()) {
        SP.UI.ModalDialog.showModalDialog({
            url: this.Url + "Overwrite.aspx?ListId=" + this.ListId + "&ItemId=" + this.ItemId,
            title: "GRIDSOFT Variations",
            allowMaximize: false,
            showClose: true,
            width: 540,
            height: 270,
            dialogReturnValueCallback: function(dialogResult, returnValue) {
                if (dialogResult == SP.UI.DialogResult.OK) {
                    SP.UI.Notify.addNotification('Variationen erfolgreich überschrieben.');
                }
            }
        });
    }
};