﻿/** prevent errors in browsers that do not support console. */
if (typeof window.console == 'undefined') { var names = ["log", "debug", "info", "warn", "error", "assert", "dir", "dirxml", "group", "groupEnd", "time", "timeEnd", "count", "trace", "profile", "profileEnd"]; window.console = {}; for (var i = 0; i < names.length; ++i) { window.console[names[i]] = function () { } } }

// build i18n literal, get current language from the url
i18n = {};
i18n.lang = window.location.pathname.substring(2, 1).toLowerCase() || "d";
i18n.formlang = i18n.lang;
i18n.pageslist = (i18n.lang == "d" ? "Seiten" : (i18n.lang == "i" ? "Pagine" : "Pages"));
i18n.cv = 'Curia Vista';
i18n.ab = 'Amtliches Bulletin';
i18n.mm = 'Medienmitteilungen';
i18n.rm = 'Ratsmitglieder seit 1848';

i18n.togglesections = 'Alle Bereiche zeigen/verstecken';
i18n.pickdate = 'Wählen Sie ein Datum';
i18n.toggleselection = 'Alle selektieren/deselektieren';
i18n.showless = 'Weniger';
i18n.showmore = 'Mehr';

switch (i18n.lang) {
    case "i":
        i18n.ab = 'Bollettino Ufficiale';
        i18n.mm = 'Comunicati Stampa';
        i18n.rm = 'Consiglieri da 1848';
        break;
        
    case "e":
        i18n.ab = 'Official Gazette';
        i18n.mm = 'Press Releases';
        i18n.rm = 'MP since 1848';
        break;
        
    case "f":
        i18n.ab = 'Bulletin Officiel';
        i18n.mm = 'Communiqués';
        i18n.rm = 'Conseillers depuis 1848';
        break;
}

function setformlabels() {
    if (i18n.formlang == "e" && $("input[name=EnglishFrenchOverride]").val() == "true") {
        i18n.formlang = "f";
    }
    switch (i18n.formlang) {
        case "i":
            i18n.togglesections = 'Mostra / nascondi tutti i campi';
            i18n.showmore = 'Tutti';
            i18n.showless = 'Riduci';
            i18n.toggleselection = 'Seleziona tutto / Annulla la selezione';
            i18n.pickdate = 'Seleziona una data';
            break;
        
        case "e":
            i18n.showmore = 'Tous'; // TODO translate
            i18n.showless = 'Réduire'; // TODO translate
            i18n.togglesections = 'Show all/hide all';
            i18n.toggleselection = 'Select all/unselect all';
            i18n.pickdate = 'Choisir une date'; // TODO translate
            break;
        
        case "f":
            i18n.showmore = 'Tous';
            i18n.showless = 'Réduire';
            i18n.togglesections = 'Afficher/masquer tous les champs';
            i18n.toggleselection = 'Cocher tout/Décocher tout';
            i18n.pickdate = 'Choisir une date';
            break;
    }
}


$(document).ready(function () {

    setformlabels();
    
    /** see class .js-hide in ParlamentCHGSServices.css */
    $(".js-hide").show();

    // create extended search picker.
    var extendedsearch = $("#extendedsearch");
    if (extendedsearch.length && $("#extendedsearch-container").length == 0) {
        extendedsearch.append(
            '<div id="extendedsearch-container">' +
            '<div id="extendedsearch-content">' +
            '<ul class="linklist">' +
            '<li><a href="/' + i18n.lang + '/suche/' + i18n.pageslist + '/curia-vista.aspx">' + i18n.cv + '</a></li>' +
            '<li><a href="/' + i18n.lang + '/suche/' + i18n.pageslist + '/amtliches-bulletin.aspx">' + i18n.ab + '</a></li>' +
            '<li><a href="/' + i18n.lang + '/suche/' + i18n.pageslist + '/medienmitteilungen.aspx">' + i18n.mm + '</a></li>' +
            '<li><a href="/' + i18n.lang + '/suche/' + i18n.pageslist + '/ratsmitglieder.aspx">' + i18n.rm + '</a></li>' +
            '</ul>' +
            '</div>' +
            '</div>');
        var searchcontainer = $("#extendedsearch-container");
        var searchtrigger = extendedsearch.find("a:first");
        searchcontainer.css("opacity", 0).hide();

        var pos = (searchtrigger.position().left - 15);
        if (jQuery.browser.msie && jQuery.browser.version.substring(0, 1) == 6) {
            pos = -16;
        }
        searchcontainer.css("left", pos + "px");

        $(searchtrigger).bind("mouseenter", function () {
            searchcontainer
                .stop(true, true)
                .show()
                .animate({ opacity: searchcontainer.css("opacity") }, 100) // delay 100ms before fading in.
                .animate({ opacity: 1 }, 500); // fade in
        });

        $(searchcontainer).bind("mouseleave", function (e) {
            // after fading out, hide the panel entirely, else the links are still clickable.        
            searchcontainer
                .stop(true, true)
                .animate({ opacity: searchcontainer.css("opacity") }, 100)
                .animate({ opacity: 0 }, 500, function () {
                    searchcontainer.hide();
                });
        });
        if (jQuery.browser.msie) {
            // fixes ie7, who did not respect mouseleave boundaries for container.
            $(searchcontainer).find("a").hover(
                function () { searchcontainer.stop(true, true); searchcontainer.css("opacity", 1); },
                function () { searchcontainer.stop(true, true); searchcontainer.css("opacity", 1); }
            );
        }
    }

    var formhelper = {
        hide: function (list, span, quick) {
            // quick -> hide on page load
            // if all children input fields do not contain value / are unchecked
            var doHide = quick ? list.find(":checkbox:checked, :radio:checked[value!='all'][value!='a'], :text[value!=''], select option:selected[index != 0]").length == 0 : true;

            if (doHide) {
                list.find("fieldset").hide();
                list.css("height", list.attr("oheight") + "px");
                list.animate({ "opacity": 0, "height": "0px" }, quick ? 1 : 300, "easeInQuad", function () {
                    // toggle class on the span element, after the animation has finished.
                    span.addClass("collapsed");
                })
                .addClass("collapsed")
            }
        },
        show: function (list, span) {
            list.animate({ "opacity": 1.0, "height": list.attr("oheight") + "px" }, 300, "easeInQuad", function () {
                // toggle class on the span element, after the animation has finished.                    
                span.removeClass("collapsed");
                list.css("height", "auto");
                list.find("fieldset").show();
            })
            .removeClass("collapsed")
        }
    };

    // add click handler to collapse/expand the fieldsets
    // which are marked up to provide this functionality
    $("fieldset.collapsible").children("legend").children("span")
        .css("cursor", "pointer")
        .css("background-image", "url('/_layouts/GridSoft/Parlament/Internet/images/fieldset.png')")
        .css("padding-left", "1.3em")
        .each(function () {
            var span = $(this);
            var list = span.parents("legend").next("ul");
            if (list.length) {
                list.attr("oheight", list.height());
            }
            if (span.parents("fieldset").hasClass("collapsed")) {
                var autoshow = !span.parents("fieldset").hasClass("noautoshow");
                formhelper.hide(list, span, autoshow);
            }
        })
        .click(function () {
            var span = $(this);
            var list = span.parents("legend").next("ul");
            if (!list.hasClass("collapsed")) {
                formhelper.hide(list, span);
            } else {
                formhelper.show(list, span);
            }
        });

    // add the toggle link above the first collapsible fieldset in the page.
    (function () {
        var fieldsets = $("fieldset.collapsible");
        if (fieldsets.length > 1) {
            var fieldset = fieldsets.get(0);
            $(fieldset).before('<a href="#" style="z-index:100" class="fieldset-collapsible-toggle">' + i18n.togglesections + '</a>');
            $(".fieldset-collapsible-toggle").click(function (event) {
                var selected = !$(this).hasClass("selected");
                $(this).toggleClass("selected");
                $("fieldset.collapsible").each(function () {
                    formhelper[selected ? "show" : "hide"]($(this).children("ul"), $(this).children("legend").children("span"));
                });
                event.preventDefault();
            });
        }
    })();


    // add the toggle link to the formlinks list, which is supposed to be
    // placed above the form.
    $(".checkboxgroup.togglelink").each(function () {
        $(this)
            .prepend('<a href="#" class="toggleselected">' + i18n.toggleselection + '</a>')
            .click(function (event) {
                var a = $(event.target);
                
                if (a.hasClass("toggleselected")) {
                    event.preventDefault();
                    
                    var parent = a.parent();
                    var inputs = parent.find("input[type=checkbox]");
                    var checked = parent.find("input[type=checkbox]:checked");
                    
                    // default behaviour: checkboxes not checked, should check them on first click.
                    var shouldCheck = !a.hasClass("selected");
                    
                    // handle first click.
                    if (!a.hasClass("initialised")) {
                        a.addClass("initialised");
                        // determine current state of checkboxes.
                        // if the link has not been clicked yet, and all checkboxes are checked,
                        // the next state is unselect all.
                        if (checked.length == inputs.length) {
                            shouldCheck = false;
                        }
                    }
                    
                    if (shouldCheck) {
                        a.addClass("selected");
                    } else {
                        a.removeClass("selected");
                    }
                    inputs.each(function () {
                        this.checked = shouldCheck;
                    });
                }
            });
    });

    // add toggle function to the multiselect lists. 
    $(".multi-select-list").each(function (i, val) {
        if ($(this).find("input").length > 3) {
            var x = $(this).parent().append('<a id="multiselect-toggle-' + i + '" style="margin: 0 0 0 5px; cursor:pointer;position: absolute;top:0;left:47em">Mehr</a>');
            $("#multiselect-toggle-" + i).click(function () {
                var div = $(this).prev();
                if (div.css("height") != "auto") {
                    $(this).text(i18n.showless);
                    div.css("height", "auto");
                } else {
                    div.css("height", "5.5em");
                    $(this).text(i18n.showmore);
                }
            });
        }
    })

    $("fieldset.datepicker").each(function () {
        $(this).append('<input type="hidden" size="10" class="hiddendate" disabled="disabled" />');

        var items = $(this).find("select");
        var day = $(items[0]), month = $(items[1]), year = $(items[2]);
        var hiddendate = $(this).find("input.hiddendate");

        $.datepicker._triggerClass = "icon ui-datepicker-trigger";
        $.datepicker._defaults.buttonText = i18n.pickdate;

        var years = year.find("option");
        hiddendate.datepicker({
            yearRange: years[years.length - 1].text + ':' + years[1].text,
            beforeShow: function () {
                var date = [];
                date.push(parseInt(day.val()) ? parseInt(day.val()) : 0);
                date.push(parseInt(month.val()) ? parseInt(month.val()) : 0);
                date.push(parseInt(year.val()) ? parseInt(year.val()) : 0);
                hiddendate.val(date.join("."));
                return {};
            },
            onSelect: function (date) {
                var p = date.split(/\//); // mm/dd/yy
                var mm = p[0].replace(/^0/, ""),
                    dd = p[1].replace(/^0/, ""),
                    yy = p[2].replace(/^0/, "");
                day.val(dd);
                month.val(mm);
                year.val(yy);
            },
            showOn: "both",
            buttonImage: "/_layouts/GridSoft/Parlament/Internet/images/calendar.gif",
            buttonImageOnly: true
        });
        $(month, year).change(function () {
            var daysInMonth = 32 - new Date(year.val(), month.val() - 1, 32).getDate();
            day.find("option").attr("disabled", "");
            day.find("option:gt(" + (daysInMonth - 1) + ")").attr("disabled", "disabled");
            if (day.val() > daysInMonth) {
                day.val(daysInMonth);
            }
        });
    });

    // decorate profile badges for detail panel   
    // hijack the click event on each of the listitems
    var list = $("ul.profilelist");

    list.parent(".ms-WPBody").css("position", "relative");
    list.children("li").children("a")
        .css("cursor", "hand")
        .click(function (event) {
            panel.hide();
            var li = $(this).parents("li");

            // find the details div inside the listitem, if it 
            // was found show the detail div, else allow default behaviour.
            var details = li.find("div.details").html();
            if (details) {
                var pos = li.position();
                event.preventDefault();

                // reposition details, and show proper content.
                var thumbnail = li.find("img");
                var src = thumbnail.attr("src").replace("/klein/", "/gross/");

                var image = panel.find("img");
                image.load(function () {
                    panel.find("div.details").html(details);
                    panel.css("top", pos.top)
                        .css("left", pos.left);

                    // only animate details if it wasn't expanded before
                    if (!panel.hasClass("expanded")) {
                        panel.css({ "opacity": 0, "display": "block" });

                        panel.animate({ "opacity": 1 }, 250, "easeInQuad", function () {
                            panel.addClass("expanded");
                        });
                    } else {
                        panel.show();
                    }
                });
                image.attr("src", src);
            }
        });

    // decorate biographie panel for close event.
    var panel = $("#profilelist-details");
    panel.click(function (event) {
        panel.removeClass("expanded");
        panel.animate({ "opacity": 0 }, 150, "easeInQuad", function () { panel.css("left", "-9999px"); });
    });

    // add toggle function to collapsible lists.
    $("li.collapsible").children("h2")
        .css("cursor", "pointer")
        .css("background-image", "url('/_layouts/GridSoft/Parlament/Internet/images/fieldset.png')")
        .css("padding-left", "1.3em");


    // print function
    $("#printicon a").click(function () {
        window.print();
    });

    // submit form fix
    $(".services-form-box").keydown(function (e) {
        var id = $(e.target).attr("id");

        if (e.keyCode == 13) {
            console.log("[ENTER] on .services-form-box > #%s", id);

            var submit = $(this).find('input:submit');
            submit.click();
        }
    });
});        
            
